import 'package:photogram_admin_cp/ui/components/layout.dart';
import 'package:rad/rad.dart';
import 'package:rad/widgets_html.dart';

import 'package:photogram_admin_cp/import/core.dart';

import 'package:photogram_admin_cp/ui/pages/common/form_editor_page.dart';

class MailerSettingsPage extends StatefulWidget {
  const MailerSettingsPage({Key? key}) : super(key: key);

  @override
  _MailerSettingsPageState createState() => _MailerSettingsPageState();
}

class _MailerSettingsPageState extends State<MailerSettingsPage> with AppActiveContentMixin {
  @override
  build(context) {
    return PageRow(
      children: [
        Division(
          className: 'col-lg-6',
          child: FormEditorPage(
            heading: 'Mailer settings',
            items: [
              SettingItem(
                intId: AppSettings.ID_SS_BOOL_MAILER_SMTP,
                settingKey: AppSettings.KEY_SS_BOOL_MAILER_SMTP,
                type: FieldType.switchable,
                leading: 'Enable SMTP',
                description: 'If not enabled, emails will be sent through standard PHP functions.',
              ),
              SettingItem(
                intId: AppSettings.ID_SS_TEXT_MAILER_SMTP_HOST,
                settingKey: AppSettings.KEY_SS_TEXT_MAILER_SMTP_HOST,
                type: FieldType.text,
                leading: 'SMTP Host Address',
                placeholder: 'Host Address',
                description: 'Address of your SMTP host.',
              ),
              SettingItem(
                intId: AppSettings.ID_SS_INT_MAILER_SMTP_PORT,
                settingKey: AppSettings.KEY_SS_INT_MAILER_SMTP_PORT,
                type: FieldType.text,
                leading: 'SMTP Server port',
                placeholder: 'Port number',
                description: 'SMTP communication endpoint that handles the transfer of email data over SMTP.',
              ),
              SettingItem(
                intId: AppSettings.ID_SS_TEXT_MAILER_SMTP_USERNAME,
                settingKey: AppSettings.KEY_SS_TEXT_MAILER_SMTP_USERNAME,
                type: FieldType.text,
                leading: 'SMTP Username',
                placeholder: 'Username',
                description: 'Part of your SMTP credentials.',
              ),
              SettingItem(
                intId: AppSettings.ID_SS_TEXT_MAILER_SMTP_PASSWORD,
                settingKey: AppSettings.KEY_SS_TEXT_MAILER_SMTP_PASSWORD,
                type: FieldType.text,
                leading: 'SMTP Password',
                placeholder: 'Password',
                description: 'Part of your SMTP credentials.',
              ),
            ],
          ),
        ),
      ],
    );
  }
}
